/*:
 * @target MZ
 * @plugindesc Setzt die globale Standardlautstärke auf 50% beim Start und Laden eines Spielstandes. Erstellt von Yui für Micha ♥
 * @author Yui
 * 
 * @help Dieses Plugin setzt beim Start des Spiels und beim Laden eines Spielstandes
 * automatisch die globale Lautstärke für BGM, BGS, ME und SE auf 50%.
 * 
 * Es gibt keine Plugin-Befehle oder Parameter.
 * 
 * Einfach installieren und fertig ♥
 */

(() => {
    const setDefaultVolume = () => {
        AudioManager.bgmVolume = 50;
        AudioManager.bgsVolume = 50;
        AudioManager.meVolume = 50;
        AudioManager.seVolume = 30;
    };

    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        setDefaultVolume();
        _Scene_Boot_start.call(this);
    };

    const _Scene_Load_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
    Scene_Load.prototype.onLoadSuccess = function() {
        _Scene_Load_onLoadSuccess.call(this);
        setDefaultVolume();
    };
})();
